/*  AR4 Annin Robot Control Software Arduino Mega sketch
    Copyright (c) 2024, Chris Annin
    All rights reserved.

    You are free to share, copy and redistribute in any medium
    or format.  You are free to remix, transform and build upon
    this material.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are met:

          Redistributions of source code must retain the above copyright
          notice, this list of conditions and the following disclaimer.
          Redistribution of this software in source or binary forms shall be free
          of all charges or fees to the recipient of this software.
          Redistributions in binary form must reproduce the above copyright
          notice, this list of conditions and the following disclaimer in the
          documentation and/or other materials provided with the distribution.
          you must give appropriate credit and indicate if changes were made. You may do
          so in any reasonable manner, but not in any way that suggests the
          licensor endorses you or your use.
          Selling AR2 software, robots, robot parts, or any versions of robots or software based on this
          work is strictly prohibited.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
    DISCLAIMED. IN NO EVENT SHALL CHRIS ANNIN BE LIABLE FOR ANY
    DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
    ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
    SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

    chris.annin@gmail.com

    Log:

*/


#include <Servo.h>

String inData;


Servo servo0;
Servo servo1;
Servo servo2;
Servo servo3;
Servo servo4;
Servo servo5;
Servo servo6;


const int Input0 = 0;
const int Input1 = 1;
const int Input2 = 2;
const int Input3 = 3;
const int Input4 = 4;
const int Input5 = 5;
const int Input6 = 6;
const int Input7 = 7;
const int Input8 = 8;
const int Input9 = 9;
const int Input10 = 10;
const int Input11 = 11;
const int Input12 = 12;
const int Input13 = 13;
const int Input14 = 14;
const int Input15 = 15;
const int Input16 = 16;
const int Input17 = 17;
const int Input18 = 18;
const int Input19 = 19;
const int Input20 = 20;
const int Input21 = 21;
const int Input22 = 22;
const int Input23 = 23;
const int Input24 = 24;
const int Input25 = 25;
const int Input26 = 26;
const int Input27 = 27;


// ---------- ACS712 (5A) current sensor ----------
const int ACS_PIN = A7;        // ACS712 AOUT wired here
const float ACS_VCC = 5.0;     // Nano analog reference
const float ACS_SENS = 0.185;  // 185 mV per amp (5A version)

int acsZeroRaw = 512;  // will be calibrated at startup

// ---- Gripper tracking ----
int gripperCmd = 20;          // last commanded gripper position
const int GRIPPER_MIN = 0;
const int GRIPPER_MAX = 45;

// ---- Current limit behavior ----
const float CURRENT_LIMIT = 0.8;           // amps
const unsigned long BACKOFF_INTERVAL = 3000; // 3 seconds

unsigned long lastBackoffMs = 0;

const int Output28 = 28;
const int Output29 = 29;
const int Output30 = 30;
const int Output31 = 31;
const int Output32 = 32;
const int Output33 = 33;
const int Output34 = 34;
const int Output35 = 35;
const int Output36 = 36;
const int Output37 = 37;
const int Output38 = 38;
const int Output39 = 39;
const int Output40 = 40;
const int Output41 = 41;
const int Output42 = 42;
const int Output43 = 43;
const int Output44 = 44;
const int Output45 = 45;
const int Output46 = 46;
const int Output47 = 47;
const int Output48 = 48;
const int Output49 = 49;
const int Output50 = 50;
const int Output51 = 51;
const int Output52 = 52;
const int Output53 = 53;


void setup() {
  // run once:
  Serial.begin(9600);

  pinMode(A0, OUTPUT);
  pinMode(A1, OUTPUT);
  pinMode(A2, OUTPUT);
  pinMode(A3, OUTPUT);
  pinMode(A4, OUTPUT);
  pinMode(A5, OUTPUT);
  pinMode(A6, OUTPUT);
  pinMode(A7, INPUT);

  pinMode(A8, INPUT);
  pinMode(A9, INPUT);
  pinMode(A10, INPUT);
  pinMode(A11, INPUT);
  pinMode(A12, INPUT);
  pinMode(A13, INPUT);
  pinMode(A14, INPUT);
  pinMode(A15, INPUT);


  pinMode(Input0, INPUT_PULLUP);
  pinMode(Input1, INPUT_PULLUP);
  pinMode(Input2, INPUT_PULLUP);
  pinMode(Input3, INPUT_PULLUP);
  pinMode(Input4, INPUT_PULLUP);
  pinMode(Input5, INPUT_PULLUP);
  pinMode(Input6, INPUT_PULLUP);
  pinMode(Input7, INPUT_PULLUP);
  pinMode(Input8, INPUT_PULLUP);
  pinMode(Input9, INPUT_PULLUP);
  pinMode(Input10, INPUT_PULLUP);
  pinMode(Input11, INPUT_PULLUP);
  pinMode(Input12, INPUT_PULLUP);
  pinMode(Input13, INPUT_PULLUP);
  pinMode(Input14, INPUT_PULLUP);
  pinMode(Input15, INPUT_PULLUP);
  pinMode(Input16, INPUT_PULLUP);
  pinMode(Input17, INPUT_PULLUP);
  pinMode(Input18, INPUT_PULLUP);
  pinMode(Input19, INPUT_PULLUP);
  pinMode(Input20, INPUT_PULLUP);
  pinMode(Input21, INPUT_PULLUP);
  pinMode(Input22, INPUT_PULLUP);
  pinMode(Input23, INPUT_PULLUP);
  pinMode(Input24, INPUT_PULLUP);
  pinMode(Input25, INPUT_PULLUP);
  pinMode(Input26, INPUT_PULLUP);
  pinMode(Input27, INPUT_PULLUP);

  pinMode(Output28, OUTPUT);
  pinMode(Output29, OUTPUT);
  pinMode(Output30, OUTPUT);
  pinMode(Output31, OUTPUT);
  pinMode(Output32, OUTPUT);
  pinMode(Output33, OUTPUT);
  pinMode(Output34, OUTPUT);
  pinMode(Output35, OUTPUT);
  pinMode(Output36, OUTPUT);
  pinMode(Output37, OUTPUT);
  pinMode(Output38, OUTPUT);
  pinMode(Output39, OUTPUT);
  pinMode(Output40, OUTPUT);
  pinMode(Output41, OUTPUT);
  pinMode(Output42, OUTPUT);
  pinMode(Output43, OUTPUT);
  pinMode(Output44, OUTPUT);
  pinMode(Output45, OUTPUT);
  pinMode(Output46, OUTPUT);
  pinMode(Output47, OUTPUT);
  pinMode(Output48, OUTPUT);
  pinMode(Output49, OUTPUT);
  pinMode(Output50, OUTPUT);
  pinMode(Output51, OUTPUT);
  pinMode(Output52, OUTPUT);
  pinMode(Output53, OUTPUT);

  servo0.attach(A0);
  servo1.attach(A1);
  servo2.attach(A2);
  servo3.attach(A3);
  servo4.attach(A4);
  servo5.attach(A5);
  servo6.attach(A6);

  digitalWrite(Output28, HIGH);
  digitalWrite(Output29, HIGH);
  digitalWrite(Output30, HIGH);
  digitalWrite(Output31, HIGH);
  digitalWrite(Output32, HIGH);
  digitalWrite(Output33, HIGH);
  digitalWrite(Output34, HIGH);
  digitalWrite(Output35, HIGH);

  servo0.write(20);

  // Calibrate ACS712 zero-current offset
  long sum = 0;
  for (int i = 0; i < 200; i++) {
    sum += analogRead(ACS_PIN);
    delay(2);
  }
  acsZeroRaw = sum / 200;

}

float readAcsCurrent() {
  const int samples = 20;
  long sum = 0;

  for (int i = 0; i < samples; i++) {
    sum += analogRead(ACS_PIN);
  }

  float raw = sum / (float)samples;

  // Convert ADC reading to voltage
  float volts = (raw * ACS_VCC) / 1023.0;
  float zeroVolts = (acsZeroRaw * ACS_VCC) / 1023.0;

  // Convert voltage difference to current
  float amps = (volts - zeroVolts) / ACS_SENS;

  // amps absolute value - magnitude
  if (amps < 0) amps = -amps;

  return amps;
}

void gripperBackoff() {
  float amps = readAcsCurrent();
  unsigned long now = millis();

  if (amps > CURRENT_LIMIT) {
    if (now - lastBackoffMs >= BACKOFF_INTERVAL) {
      lastBackoffMs = now;

      if (gripperCmd < GRIPPER_MAX) {
        gripperCmd += .25;                   
        if (gripperCmd > GRIPPER_MAX) gripperCmd = GRIPPER_MAX;

        servo0.write(gripperCmd);
      }
    }
  } else {
    // below threshold → reset timer so it must stay high again
    lastBackoffMs = now;
  }
}

void loop() {
  //start loop
  gripperBackoff();
  while (Serial.available() > 0) {
    char recieved = Serial.read();
    inData += recieved;
    // Process message when new line character is recieved
    if (recieved == '\n') {
      String function = inData.substring(0, 2);

      //-----COMMAND TEST GRIPPER AMPERAGE---------------------------------------------------
      //-----------------------------------------------------------------------
      if (function == "TG") {
        int raw = analogRead(A7);
        float volts = raw * (5.0 / 1023.0);
        Serial.println(readAcsCurrent(), 3);
        //Serial.println(volts, 3);
      }


      //-----COMMAND TO MOVE SERVO---------------------------------------------------
      //-----------------------------------------------------------------------
      if (function == "SV") {
        int SVstart = inData.indexOf('V');
        int POSstart = inData.indexOf('P');
        int servoNum = inData.substring(SVstart + 1, POSstart).toInt();
        int servoPOS = inData.substring(POSstart + 1).toInt();
        if (servoNum == 0) {
          gripperCmd = servoPOS;
          servo0.write(gripperCmd);
        }
        if (servoNum == 1) {
          servo1.write(servoPOS);
        }
        if (servoNum == 2) {
          servo2.write(servoPOS);
        }
        if (servoNum == 3) {
          servo3.write(servoPOS);
        }
        if (servoNum == 4) {
          servo4.write(servoPOS);
        }
        if (servoNum == 5) {
          servo5.write(servoPOS);
        }
        if (servoNum == 6) {
          servo6.write(servoPOS);
        }

        Serial.print("Servo Done");
      }


      //-----COMMAND IF INPUT THEN JUMP---------------------------------------------------
      //-----------------------------------------------------------------------
      if (function == "JF") {
        int IJstart = inData.indexOf('X');
        int IJTabstart = inData.indexOf('T');
        int IJInputNum = inData.substring(IJstart + 1, IJTabstart).toInt();
        if (digitalRead(IJInputNum) == HIGH) {
          Serial.println("T");
        }
        if (digitalRead(IJInputNum) == LOW) {
          Serial.println("F");
        }
      }
      //-----COMMAND SET OUTPUT ON---------------------------------------------------
      //-----------------------------------------------------------------------
      if (function == "ON") {
        int ONstart = inData.indexOf('X');
        int outputNum = inData.substring(ONstart + 1).toInt();
        digitalWrite(outputNum, HIGH);
        Serial.print("Done");
      }
      //-----COMMAND SET OUTPUT OFF---------------------------------------------------
      //-----------------------------------------------------------------------
      if (function == "OF") {
        int ONstart = inData.indexOf('X');
        int outputNum = inData.substring(ONstart + 1).toInt();
        digitalWrite(outputNum, LOW);
        Serial.print("Done");
      }
      //-----COMMAND TO WAIT 5v INPUT---------------------------------------------------
      //-----------------------------------------------------------------------
      if (function == "WI") {
        int inputVal = -1;
        int inputIndex = inData.indexOf('A');
        int valueIndex = inData.indexOf('B');
        int timoutIndex = inData.indexOf('C');
        int input = inData.substring(inputIndex + 1, valueIndex).toInt();
        int value = inData.substring(valueIndex + 1, timoutIndex).toInt();
        int timeout = inData.substring(timoutIndex + 1).toInt();
        unsigned long timeoutMillis = timeout * 1000;
        unsigned long startTime = millis();
        while ((millis() - startTime < timeoutMillis) && (inputVal != value)) {
          inputVal = digitalRead(input);
          delay(100);
        }
        delay(5);
        Serial.print("Done");
      }

      //-----COMMAND ECHO TEST MESSAGE---------------------------------------------------
      //-----------------------------------------------------------------------
      if (function == "TM") {
        String echo = inData.substring(2);
        Serial.println(echo);
      }




      else {
        inData = "";  // Clear recieved buffer
      }
    }
  }
}
